////////////////////////////////////////////////////
// File:	"CCreditsState.h"
//
// Author:	Jason Stegner (JS)
//
// Purpose: Creates and displays the credits screen for the game.
////////////////////////////////////////////////////

#ifndef CCREDITSSTATE_H_
#define CCREDITSSTATE_H_

#include "IGameState.h"
#include "CBitmapFontManager.h"
#include "CBitmapFont.h"
#include <string>
#include <list>
using std::string;
using std::list;

class CCreditsState : public IGameState
{
private:
	//	ID for background image
	int						m_nStaffID;
	// sound ID for the state
	int						m_nSoundID;
	int						m_nTeamLogo;
	float					m_fTeamLogoPosX;
	int						m_nGlobalGamJamLogo;
	int						m_nIGDSLogo;
	int						m_nFullSailLogo;

	struct tTextScroll
	{
		string szText;
		float defaultX, defaultY;
		float currentX, currentY;
	};

	list<tTextScroll> m_vCredits1;
	list<tTextScroll> m_vCredits2;
	list<tTextScroll> m_vCredits3;
	list<tTextScroll> m_vCredits4;

	CBitmapFontManager* m_pBM;
	CBitmapFont m_pFont;


	///////////////////////////////////////////////
	//	Function:	"CCreditsState"
	//	Purpose:	Constructor
	///////////////////////////////////////////////
	CCreditsState();
	///////////////////////////////////////////////
	//	Function:	"~CCreditsState"
	//	Purpose:	Destructor
	///////////////////////////////////////////////
	~CCreditsState();
	///////////////////////////////////////////////
	//	Function:	"CCreditsState"
	//	Purpose:	Copy constructor
	///////////////////////////////////////////////
	CCreditsState(const CCreditsState&);
	///////////////////////////////////////////////
	//	Function:	"operator="
	//	Purpose:	Overloaded assignment operator
	///////////////////////////////////////////////
	CCreditsState& operator=(const CCreditsState&);
public:
	///////////////////////////////////////////////
	//	Function:	"GetInstance"
	//	Purpose:	Returns the instance of the Credits State
	///////////////////////////////////////////////
	static CCreditsState* GetInstance();
	///////////////////////////////////////////////
	//	Function:	"Enter"
	//	Purpose:	Starts up the Credits State
	///////////////////////////////////////////////
	void Enter();
	///////////////////////////////////////////////
	//	Function:	"Input"
	//	Purpose:	Takes in and handles input for the Credits State
	///////////////////////////////////////////////
	bool Input(float fElapsedTime);
	///////////////////////////////////////////////
	//	Function:	"Update"
	//	Purpose:	Updates the Credits State
	///////////////////////////////////////////////
	void Update(float fElapsedTime);
	///////////////////////////////////////////////
	//	Function:	"Render"
	//	Purpose:	Draws the Credits State
	///////////////////////////////////////////////
	void Render();
	///////////////////////////////////////////////
	//	Function:	"Exit"
	//	Purpose:	Shuts down the Credits State
	///////////////////////////////////////////////
	void Exit();
};

#endif
